# Numbers

## Numeric types

The most important numeric type that are used by default are

::data[Builtin/Integer, Builtin/Double]

SCL standard library defines also other integer and floating point number types:

::data[Builtin/Short, Builtin/Long, Builtin/Float, BigInteger/BigInteger]

## Basic operations on numbers

::value[Prelude/+,Prelude/-,Prelude/neg,Prelude/*,Prelude//]
::value[Prelude/^,Prelude/sqrt,Prelude/exp,Prelude/log]
::value[Prelude/pi,Prelude/sin,Prelude/cos,Prelude/tan,Prelude/asin,Prelude/acos,Prelude/atan,Prelude/atan2]
::value[Prelude/min,Prelude/max,Prelude/abs,Prelude/floor,Prelude/ceil]
::value[Prelude/div,Prelude/mod]

## Comparison

::value[Prelude/==,Prelude/!=]
::value[Prelude/<,Prelude/<=,Prelude/>,Prelude/>=]

## Conversion between numerical types

::value[Prelude/fromInteger,Prelude/toInteger,Prelude/fromDouble,Prelude/toDouble]

## Numerical operations on lists

::value[Prelude/sum,Prelude/maximum,Prelude/minimum]